/* packet-tango.c
 *
 * $Id$
 *
 * Routines for IDL dissection
 *
 * Autogenerated from idl2wrs
 * Copyright 2001 Frank Singleton <frank.singleton@ericsson.com>
 */


/*
 * Wireshark - Network traffic analyzer
 * By Gerald Combs
 * Copyright 1999 - 2012 Gerald Combs
 */

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#include "config.h"

#include <gmodule.h>

#include <string.h>
#include <glib.h>
#include <epan/packet.h>
#include <epan/proto.h>
#include <epan/dissectors/packet-giop.h>
#include <epan/expert.h>

#ifdef _MSC_VER
/* disable warning: "unreference local variable" */
#pragma warning(disable:4101)
#endif


/* Initialise the protocol and subtree pointers */
static int proto_tango = -1;
static gint ett_tango = -1;


/* Initialise the initial Alignment */
static guint32  boundary = GIOP_HEADER_SIZE;  /* initial value */

static int hf_operationrequest = -1;/* Request_Operation field */

        /* Operation filters */
static int hf_Tango_Device_command_inout_return = -1;
static int hf_Tango_Device_command_inout_command = -1;
static int hf_Tango_Device_command_inout_argin = -1;
static int hf_Tango_Device_get_attribute_config_return = -1;
static int hf_Tango_Device_get_attribute_config_names = -1;
static int hf_Tango_Device_set_attribute_config_new_conf = -1;
static int hf_Tango_Device_read_attributes_return = -1;
static int hf_Tango_Device_read_attributes_names = -1;
static int hf_Tango_Device_write_attributes_values = -1;
static int hf_Tango_Device_black_box_return = -1;
static int hf_Tango_Device_black_box_n = -1;
static int hf_Tango_Device_info_return = -1;
static int hf_Tango_Device_command_list_query_return = -1;
static int hf_Tango_Device_command_query_return = -1;
static int hf_Tango_Device_command_query_command = -1;
static int hf_Tango_Device_2_command_inout_2_return = -1;
static int hf_Tango_Device_2_command_inout_2_command = -1;
static int hf_Tango_Device_2_command_inout_2_argin = -1;
static int hf_Tango_Device_2_command_inout_2_source = -1;
static int hf_Tango_Device_2_read_attributes_2_return = -1;
static int hf_Tango_Device_2_read_attributes_2_names = -1;
static int hf_Tango_Device_2_read_attributes_2_source = -1;
static int hf_Tango_Device_2_get_attribute_config_2_return = -1;
static int hf_Tango_Device_2_get_attribute_config_2_names = -1;
static int hf_Tango_Device_2_command_list_query_2_return = -1;
static int hf_Tango_Device_2_command_query_2_return = -1;
static int hf_Tango_Device_2_command_query_2_command = -1;
static int hf_Tango_Device_2_command_inout_history_2_return = -1;
static int hf_Tango_Device_2_command_inout_history_2_command = -1;
static int hf_Tango_Device_2_command_inout_history_2_n = -1;
static int hf_Tango_Device_2_read_attribute_history_2_return = -1;
static int hf_Tango_Device_2_read_attribute_history_2_name = -1;
static int hf_Tango_Device_2_read_attribute_history_2_n = -1;
static int hf_Tango_Device_3_read_attributes_3_return = -1;
static int hf_Tango_Device_3_read_attributes_3_names = -1;
static int hf_Tango_Device_3_read_attributes_3_source = -1;
static int hf_Tango_Device_3_write_attributes_3_values = -1;
static int hf_Tango_Device_3_read_attribute_history_3_return = -1;
static int hf_Tango_Device_3_read_attribute_history_3_name = -1;
static int hf_Tango_Device_3_read_attribute_history_3_n = -1;
static int hf_Tango_Device_3_info_3_return = -1;
static int hf_Tango_Device_3_get_attribute_config_3_return = -1;
static int hf_Tango_Device_3_get_attribute_config_3_names = -1;
static int hf_Tango_Device_3_set_attribute_config_3_new_conf = -1;
        /* Attribute filters */
static int hf_get_Tango_Device_name_name = -1;
static int hf_get_Tango_Device_description_description = -1;
static int hf_get_Tango_Device_state_state = -1;
static int hf_get_Tango_Device_status_status = -1;
static int hf_get_Tango_Device_adm_name_adm_name = -1;
        /* Struct filters */
static int hf_Tango_DevVarLongStringArray_lvalue = -1;
static int hf_Tango_DevVarLongStringArray_svalue = -1;
static int hf_Tango_DevVarDoubleStringArray_dvalue = -1;
static int hf_Tango_DevVarDoubleStringArray_svalue = -1;
static int hf_Tango_TimeVal_tv_sec = -1;
static int hf_Tango_TimeVal_tv_usec = -1;
static int hf_Tango_TimeVal_tv_nsec = -1;
static int hf_Tango_DevCmdInfo_cmd_name = -1;
static int hf_Tango_DevCmdInfo_cmd_tag = -1;
static int hf_Tango_DevCmdInfo_in_type = -1;
static int hf_Tango_DevCmdInfo_out_type = -1;
static int hf_Tango_DevCmdInfo_in_type_desc = -1;
static int hf_Tango_DevCmdInfo_out_type_desc = -1;
static int hf_Tango_DevCmdInfo_2_cmd_name = -1;
static int hf_Tango_DevCmdInfo_2_level = -1;
static int hf_Tango_DevCmdInfo_2_cmd_tag = -1;
static int hf_Tango_DevCmdInfo_2_in_type = -1;
static int hf_Tango_DevCmdInfo_2_out_type = -1;
static int hf_Tango_DevCmdInfo_2_in_type_desc = -1;
static int hf_Tango_DevCmdInfo_2_out_type_desc = -1;
static int hf_Tango_DevError_reason = -1;
static int hf_Tango_DevError_severity = -1;
static int hf_Tango_DevError_desc = -1;
static int hf_Tango_DevError_origin = -1;
static int hf_Tango_NamedDevError_name = -1;
static int hf_Tango_NamedDevError_index_in_call = -1;
static int hf_Tango_NamedDevError_err_list = -1;
static int hf_Tango_AttributeConfig_name = -1;
static int hf_Tango_AttributeConfig_writable = -1;
static int hf_Tango_AttributeConfig_data_format = -1;
static int hf_Tango_AttributeConfig_data_type = -1;
static int hf_Tango_AttributeConfig_max_dim_x = -1;
static int hf_Tango_AttributeConfig_max_dim_y = -1;
static int hf_Tango_AttributeConfig_description = -1;
static int hf_Tango_AttributeConfig_label = -1;
static int hf_Tango_AttributeConfig_unit = -1;
static int hf_Tango_AttributeConfig_standard_unit = -1;
static int hf_Tango_AttributeConfig_display_unit = -1;
static int hf_Tango_AttributeConfig_format = -1;
static int hf_Tango_AttributeConfig_min_value = -1;
static int hf_Tango_AttributeConfig_max_value = -1;
static int hf_Tango_AttributeConfig_min_alarm = -1;
static int hf_Tango_AttributeConfig_max_alarm = -1;
static int hf_Tango_AttributeConfig_writable_attr_name = -1;
static int hf_Tango_AttributeConfig_extensions = -1;
static int hf_Tango_AttributeConfig_2_name = -1;
static int hf_Tango_AttributeConfig_2_writable = -1;
static int hf_Tango_AttributeConfig_2_data_format = -1;
static int hf_Tango_AttributeConfig_2_data_type = -1;
static int hf_Tango_AttributeConfig_2_max_dim_x = -1;
static int hf_Tango_AttributeConfig_2_max_dim_y = -1;
static int hf_Tango_AttributeConfig_2_description = -1;
static int hf_Tango_AttributeConfig_2_label = -1;
static int hf_Tango_AttributeConfig_2_unit = -1;
static int hf_Tango_AttributeConfig_2_standard_unit = -1;
static int hf_Tango_AttributeConfig_2_display_unit = -1;
static int hf_Tango_AttributeConfig_2_format = -1;
static int hf_Tango_AttributeConfig_2_min_value = -1;
static int hf_Tango_AttributeConfig_2_max_value = -1;
static int hf_Tango_AttributeConfig_2_min_alarm = -1;
static int hf_Tango_AttributeConfig_2_max_alarm = -1;
static int hf_Tango_AttributeConfig_2_writable_attr_name = -1;
static int hf_Tango_AttributeConfig_2_level = -1;
static int hf_Tango_AttributeConfig_2_extensions = -1;
static int hf_Tango_AttributeValue_value = -1;
static int hf_Tango_AttributeValue_quality = -1;
static int hf_Tango_AttributeValue_time = -1;
static int hf_Tango_AttributeValue_name = -1;
static int hf_Tango_AttributeValue_dim_x = -1;
static int hf_Tango_AttributeValue_dim_y = -1;
static int hf_Tango_AttributeDim_dim_x = -1;
static int hf_Tango_AttributeDim_dim_y = -1;
static int hf_Tango_AttributeValue_3_value = -1;
static int hf_Tango_AttributeValue_3_quality = -1;
static int hf_Tango_AttributeValue_3_time = -1;
static int hf_Tango_AttributeValue_3_name = -1;
static int hf_Tango_AttributeValue_3_r_dim = -1;
static int hf_Tango_AttributeValue_3_w_dim = -1;
static int hf_Tango_AttributeValue_3_err_list = -1;
static int hf_Tango_ChangeEventProp_rel_change = -1;
static int hf_Tango_ChangeEventProp_abs_change = -1;
static int hf_Tango_ChangeEventProp_extensions = -1;
static int hf_Tango_PeriodicEventProp_period = -1;
static int hf_Tango_PeriodicEventProp_extensions = -1;
static int hf_Tango_ArchiveEventProp_rel_change = -1;
static int hf_Tango_ArchiveEventProp_abs_change = -1;
static int hf_Tango_ArchiveEventProp_period = -1;
static int hf_Tango_ArchiveEventProp_extensions = -1;
static int hf_Tango_EventProperties_ch_event = -1;
static int hf_Tango_EventProperties_per_event = -1;
static int hf_Tango_EventProperties_arch_event = -1;
static int hf_Tango_AttributeAlarm_min_alarm = -1;
static int hf_Tango_AttributeAlarm_max_alarm = -1;
static int hf_Tango_AttributeAlarm_min_warning = -1;
static int hf_Tango_AttributeAlarm_max_warning = -1;
static int hf_Tango_AttributeAlarm_delta_t = -1;
static int hf_Tango_AttributeAlarm_delta_val = -1;
static int hf_Tango_AttributeAlarm_extensions = -1;
static int hf_Tango_AttributeConfig_3_name = -1;
static int hf_Tango_AttributeConfig_3_writable = -1;
static int hf_Tango_AttributeConfig_3_data_format = -1;
static int hf_Tango_AttributeConfig_3_data_type = -1;
static int hf_Tango_AttributeConfig_3_max_dim_x = -1;
static int hf_Tango_AttributeConfig_3_max_dim_y = -1;
static int hf_Tango_AttributeConfig_3_description = -1;
static int hf_Tango_AttributeConfig_3_label = -1;
static int hf_Tango_AttributeConfig_3_unit = -1;
static int hf_Tango_AttributeConfig_3_standard_unit = -1;
static int hf_Tango_AttributeConfig_3_display_unit = -1;
static int hf_Tango_AttributeConfig_3_format = -1;
static int hf_Tango_AttributeConfig_3_min_value = -1;
static int hf_Tango_AttributeConfig_3_max_value = -1;
static int hf_Tango_AttributeConfig_3_writable_attr_name = -1;
static int hf_Tango_AttributeConfig_3_level = -1;
static int hf_Tango_AttributeConfig_3_att_alarm = -1;
static int hf_Tango_AttributeConfig_3_event_prop = -1;
static int hf_Tango_AttributeConfig_3_extensions = -1;
static int hf_Tango_AttributeConfig_3_sys_extensions = -1;
static int hf_Tango_DevInfo_dev_class = -1;
static int hf_Tango_DevInfo_server_id = -1;
static int hf_Tango_DevInfo_server_host = -1;
static int hf_Tango_DevInfo_server_version = -1;
static int hf_Tango_DevInfo_doc_url = -1;
static int hf_Tango_DevInfo_3_dev_class = -1;
static int hf_Tango_DevInfo_3_server_id = -1;
static int hf_Tango_DevInfo_3_server_host = -1;
static int hf_Tango_DevInfo_3_server_version = -1;
static int hf_Tango_DevInfo_3_doc_url = -1;
static int hf_Tango_DevInfo_3_dev_type = -1;
static int hf_Tango_DevCmdHistory_time = -1;
static int hf_Tango_DevCmdHistory_cmd_failed = -1;
static int hf_Tango_DevCmdHistory_value = -1;
static int hf_Tango_DevCmdHistory_errors = -1;
static int hf_Tango_DevAttrHistory_attr_failed = -1;
static int hf_Tango_DevAttrHistory_value = -1;
static int hf_Tango_DevAttrHistory_errors = -1;
static int hf_Tango_DevAttrHistory_3_attr_failed = -1;
static int hf_Tango_DevAttrHistory_3_value = -1;
        /* User exception filters */
static int hf_Tango_DevFailed_errors = -1;
static int hf_Tango_MultiDevFailed_errors = -1;
        /* Expert info filters */
static expert_field ei_tango_unknown_giop_msg = EI_INIT;
static expert_field ei_tango_unknown_exception = EI_INIT;
static expert_field ei_tango_unknown_reply_status = EI_INIT;


static proto_tree *start_dissecting(tvbuff_t *tvb, packet_info *pinfo, proto_tree *ptree, int *offset);


/* Struct prototype declaration Start */

/* Struct = IDL:Tango/DevVarLongStringArray:1.0 */
static void decode_Tango_DevVarLongStringArray_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:Tango/DevVarDoubleStringArray:1.0 */
static void decode_Tango_DevVarDoubleStringArray_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:Tango/TimeVal:1.0 */
static void decode_Tango_TimeVal_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:Tango/DevCmdInfo:1.0 */
static void decode_Tango_DevCmdInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:Tango/DevCmdInfo_2:1.0 */
static void decode_Tango_DevCmdInfo_2_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:Tango/DevError:1.0 */
static void decode_Tango_DevError_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:Tango/NamedDevError:1.0 */
static void decode_Tango_NamedDevError_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:Tango/AttributeConfig:1.0 */
static void decode_Tango_AttributeConfig_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:Tango/AttributeConfig_2:1.0 */
static void decode_Tango_AttributeConfig_2_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:Tango/AttributeValue:1.0 */
static void decode_Tango_AttributeValue_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:Tango/AttributeDim:1.0 */
static void decode_Tango_AttributeDim_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:Tango/AttributeValue_3:1.0 */
static void decode_Tango_AttributeValue_3_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:Tango/ChangeEventProp:1.0 */
static void decode_Tango_ChangeEventProp_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:Tango/PeriodicEventProp:1.0 */
static void decode_Tango_PeriodicEventProp_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:Tango/ArchiveEventProp:1.0 */
static void decode_Tango_ArchiveEventProp_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:Tango/EventProperties:1.0 */
static void decode_Tango_EventProperties_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:Tango/AttributeAlarm:1.0 */
static void decode_Tango_AttributeAlarm_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:Tango/AttributeConfig_3:1.0 */
static void decode_Tango_AttributeConfig_3_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:Tango/DevInfo:1.0 */
static void decode_Tango_DevInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:Tango/DevInfo_3:1.0 */
static void decode_Tango_DevInfo_3_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:Tango/DevCmdHistory:1.0 */
static void decode_Tango_DevCmdHistory_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:Tango/DevAttrHistory:1.0 */
static void decode_Tango_DevAttrHistory_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:Tango/DevAttrHistory_3:1.0 */
static void decode_Tango_DevAttrHistory_3_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct prototype declaration End */

/*
 * IDL Attributes Start
 */

static const char get_Tango_Device_name_at[] = "_get_name" ;
static const char get_Tango_Device_description_at[] = "_get_description" ;
static const char get_Tango_Device_state_at[] = "_get_state" ;
static const char get_Tango_Device_status_at[] = "_get_status" ;
static const char get_Tango_Device_adm_name_at[] = "_get_adm_name" ;

/*
 * IDL Attributes End
 */

/*
 * IDL Enums Start
 */

/*
 * Enum = IDL:Tango/AttrQuality:1.0
 */
static const value_string Tango_AttrQuality[] = {

   { 0, "ATTR_VALID" },
   { 1, "ATTR_INVALID" },
   { 2, "ATTR_ALARM" },
   { 3, "ATTR_CHANGING" },
   { 4, "ATTR_WARNING" },
   { 0,       NULL },
};

/*
 * Enum = IDL:Tango/AttrWriteType:1.0
 */
static const value_string Tango_AttrWriteType[] = {

   { 0, "READ" },
   { 1, "READ_WITH_WRITE" },
   { 2, "WRITE" },
   { 3, "READ_WRITE" },
   { 0,       NULL },
};

/*
 * Enum = IDL:Tango/AttrDataFormat:1.0
 */
static const value_string Tango_AttrDataFormat[] = {

   { 0, "SCALAR" },
   { 1, "SPECTRUM" },
   { 2, "IMAGE" },
   { 0,       NULL },
};

/*
 * Enum = IDL:Tango/DevSource:1.0
 */
static const value_string Tango_DevSource[] = {

   { 0, "DEV" },
   { 1, "CACHE" },
   { 2, "CACHE_DEV" },
   { 0,       NULL },
};

/*
 * Enum = IDL:Tango/ErrSeverity:1.0
 */
static const value_string Tango_ErrSeverity[] = {

   { 0, "WARN" },
   { 1, "ERR" },
   { 2, "PANIC" },
   { 0,       NULL },
};

/*
 * Enum = IDL:Tango/DevState:1.0
 */
static const value_string Tango_DevState[] = {

   { 0, "ON" },
   { 1, "OFF" },
   { 2, "CLOSE" },
   { 3, "OPEN" },
   { 4, "INSERT" },
   { 5, "EXTRACT" },
   { 6, "MOVING" },
   { 7, "STANDBY" },
   { 8, "FAULT" },
   { 9, "INIT" },
   { 10, "RUNNING" },
   { 11, "ALARM" },
   { 12, "DISABLE" },
   { 13, "UNKNOWN" },
   { 0,       NULL },
};

/*
 * Enum = IDL:Tango/DispLevel:1.0
 */
static const value_string Tango_DispLevel[] = {

   { 0, "OPERATOR" },
   { 1, "EXPERT" },
   { 0,       NULL },
};

/*
 * IDL Enums End
 */

/*  Begin Exception Helper Functions  */


/* Exception = IDL:Tango/DevFailed:1.0 */
static void
decode_ex_Tango_DevFailed(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_DevFailed_errors;
    guint32   i_Tango_DevFailed_errors;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    u_octet4_loop_Tango_DevFailed_errors = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_DevFailed_errors, tvb,*offset-4, 4, u_octet4_loop_Tango_DevFailed_errors);

    for (i_Tango_DevFailed_errors=0; i_Tango_DevFailed_errors < u_octet4_loop_Tango_DevFailed_errors; i_Tango_DevFailed_errors++) {

        /*  Begin struct "Tango_DevError"  */
        decode_Tango_DevError_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "Tango_DevError"  */
    }

}

/* Exception = IDL:Tango/MultiDevFailed:1.0 */
static void
decode_ex_Tango_MultiDevFailed(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_MultiDevFailed_errors;
    guint32   i_Tango_MultiDevFailed_errors;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    u_octet4_loop_Tango_MultiDevFailed_errors = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_MultiDevFailed_errors, tvb,*offset-4, 4, u_octet4_loop_Tango_MultiDevFailed_errors);

    for (i_Tango_MultiDevFailed_errors=0; i_Tango_MultiDevFailed_errors < u_octet4_loop_Tango_MultiDevFailed_errors; i_Tango_MultiDevFailed_errors++) {

        /*  Begin struct "Tango_NamedDevError"  */
        decode_Tango_NamedDevError_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "Tango_NamedDevError"  */
    }

}


/*  End Exception Helper Functions  */

/*
 * Main delegator for exception handling
 *
 */
static gboolean
decode_user_exception(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *ptree _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_tree *tree _U_;

    if (!header->exception_id)
        return FALSE;

    if (strcmp(header->exception_id, "IDL:Tango/DevFailed:1.0") == 0) {
       tree = start_dissecting(tvb, pinfo, ptree, offset);
       decode_ex_Tango_DevFailed(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:Tango/DevFailed:1.0  */
       return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:Tango/MultiDevFailed:1.0") == 0) {
       tree = start_dissecting(tvb, pinfo, ptree, offset);
       decode_ex_Tango_MultiDevFailed(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:Tango/MultiDevFailed:1.0  */
       return TRUE;
    }


    return FALSE;    /* user exception not found */
}

/*  Begin Attribute Helper Functions  */


/* Attribute = IDL:Tango/Device/name:1.0 */
static void
decode_get_Tango_Device_name_at(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item* item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_get_Tango_Device_name_name);

}


/* Attribute = IDL:Tango/Device/description:1.0 */
static void
decode_get_Tango_Device_description_at(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item* item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_get_Tango_Device_description_description);

}


/* Attribute = IDL:Tango/Device/state:1.0 */
static void
decode_get_Tango_Device_state_at(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item* item _U_;

    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_get_Tango_Device_state_state, tvb, *offset-4, 4, u_octet4);

}


/* Attribute = IDL:Tango/Device/status:1.0 */
static void
decode_get_Tango_Device_status_at(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item* item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_get_Tango_Device_status_status);

}


/* Attribute = IDL:Tango/Device/adm_name:1.0 */
static void
decode_get_Tango_Device_adm_name_at(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item* item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_get_Tango_Device_adm_name_adm_name);

}


/*  End Attribute Helper Functions  */

/*
 * IDL:Tango/Device/command_inout:1.0
 */
static void
decode_Tango_Device_command_inout(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_Device_command_inout_command);

        get_CDR_any(tvb, pinfo, tree, item, offset, stream_is_big_endian, boundary, header);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            get_CDR_any(tvb, pinfo, tree, item, offset, stream_is_big_endian, boundary, header);

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_tango_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_tango_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:Tango/Device/get_attribute_config:1.0
 */
static void
decode_Tango_Device_get_attribute_config(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_Device_get_attribute_config_names;
    guint32   i_Tango_Device_get_attribute_config_names;
    guint32   u_octet4_loop_Tango_Device_get_attribute_config_return;
    guint32   i_Tango_Device_get_attribute_config_return;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_Tango_Device_get_attribute_config_names = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        /* coverity[returned_pointer] */
        item = proto_tree_add_uint(tree, hf_Tango_Device_get_attribute_config_names, tvb,*offset-4, 4, u_octet4_loop_Tango_Device_get_attribute_config_names);

        for (i_Tango_Device_get_attribute_config_names=0; i_Tango_Device_get_attribute_config_names < u_octet4_loop_Tango_Device_get_attribute_config_names; i_Tango_Device_get_attribute_config_names++) {

            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_Device_get_attribute_config_names);

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_Tango_Device_get_attribute_config_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            /* coverity[returned_pointer] */
            item = proto_tree_add_uint(tree, hf_Tango_Device_get_attribute_config_return, tvb,*offset-4, 4, u_octet4_loop_Tango_Device_get_attribute_config_return);

            for (i_Tango_Device_get_attribute_config_return=0; i_Tango_Device_get_attribute_config_return < u_octet4_loop_Tango_Device_get_attribute_config_return; i_Tango_Device_get_attribute_config_return++) {

                /*  Begin struct "Tango_AttributeConfig"  */
                decode_Tango_AttributeConfig_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
                /*  End struct "Tango_AttributeConfig"  */
            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_tango_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_tango_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:Tango/Device/set_attribute_config:1.0
 */
static void
decode_Tango_Device_set_attribute_config(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_Device_set_attribute_config_new_conf;
    guint32   i_Tango_Device_set_attribute_config_new_conf;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_Tango_Device_set_attribute_config_new_conf = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        /* coverity[returned_pointer] */
        item = proto_tree_add_uint(tree, hf_Tango_Device_set_attribute_config_new_conf, tvb,*offset-4, 4, u_octet4_loop_Tango_Device_set_attribute_config_new_conf);

        for (i_Tango_Device_set_attribute_config_new_conf=0; i_Tango_Device_set_attribute_config_new_conf < u_octet4_loop_Tango_Device_set_attribute_config_new_conf; i_Tango_Device_set_attribute_config_new_conf++) {

            /*  Begin struct "Tango_AttributeConfig"  */
            decode_Tango_AttributeConfig_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "Tango_AttributeConfig"  */
        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_tango_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_tango_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:Tango/Device/read_attributes:1.0
 */
static void
decode_Tango_Device_read_attributes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_Device_read_attributes_names;
    guint32   i_Tango_Device_read_attributes_names;
    guint32   u_octet4_loop_Tango_Device_read_attributes_return;
    guint32   i_Tango_Device_read_attributes_return;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_Tango_Device_read_attributes_names = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        /* coverity[returned_pointer] */
        item = proto_tree_add_uint(tree, hf_Tango_Device_read_attributes_names, tvb,*offset-4, 4, u_octet4_loop_Tango_Device_read_attributes_names);

        for (i_Tango_Device_read_attributes_names=0; i_Tango_Device_read_attributes_names < u_octet4_loop_Tango_Device_read_attributes_names; i_Tango_Device_read_attributes_names++) {

            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_Device_read_attributes_names);

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_Tango_Device_read_attributes_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            /* coverity[returned_pointer] */
            item = proto_tree_add_uint(tree, hf_Tango_Device_read_attributes_return, tvb,*offset-4, 4, u_octet4_loop_Tango_Device_read_attributes_return);

            for (i_Tango_Device_read_attributes_return=0; i_Tango_Device_read_attributes_return < u_octet4_loop_Tango_Device_read_attributes_return; i_Tango_Device_read_attributes_return++) {

                /*  Begin struct "Tango_AttributeValue"  */
                decode_Tango_AttributeValue_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
                /*  End struct "Tango_AttributeValue"  */
            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_tango_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_tango_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:Tango/Device/write_attributes:1.0
 */
static void
decode_Tango_Device_write_attributes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_Device_write_attributes_values;
    guint32   i_Tango_Device_write_attributes_values;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_Tango_Device_write_attributes_values = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        /* coverity[returned_pointer] */
        item = proto_tree_add_uint(tree, hf_Tango_Device_write_attributes_values, tvb,*offset-4, 4, u_octet4_loop_Tango_Device_write_attributes_values);

        for (i_Tango_Device_write_attributes_values=0; i_Tango_Device_write_attributes_values < u_octet4_loop_Tango_Device_write_attributes_values; i_Tango_Device_write_attributes_values++) {

            /*  Begin struct "Tango_AttributeValue"  */
            decode_Tango_AttributeValue_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "Tango_AttributeValue"  */
        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_tango_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_tango_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:Tango/Device/ping:1.0
 */
static void
decode_Tango_Device_ping(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_tango_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_tango_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:Tango/Device/black_box:1.0
 */
static void
decode_Tango_Device_black_box(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_Device_black_box_return;
    guint32   i_Tango_Device_black_box_return;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_Tango_Device_black_box_n, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_Tango_Device_black_box_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            /* coverity[returned_pointer] */
            item = proto_tree_add_uint(tree, hf_Tango_Device_black_box_return, tvb,*offset-4, 4, u_octet4_loop_Tango_Device_black_box_return);

            for (i_Tango_Device_black_box_return=0; i_Tango_Device_black_box_return < u_octet4_loop_Tango_Device_black_box_return; i_Tango_Device_black_box_return++) {

                giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_Device_black_box_return);

            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_tango_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_tango_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:Tango/Device/info:1.0
 */
static void
decode_Tango_Device_info(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /*  Begin struct "Tango_DevInfo"  */
            decode_Tango_DevInfo_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "Tango_DevInfo"  */
            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_tango_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_tango_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:Tango/Device/command_list_query:1.0
 */
static void
decode_Tango_Device_command_list_query(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_Device_command_list_query_return;
    guint32   i_Tango_Device_command_list_query_return;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_Tango_Device_command_list_query_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            /* coverity[returned_pointer] */
            item = proto_tree_add_uint(tree, hf_Tango_Device_command_list_query_return, tvb,*offset-4, 4, u_octet4_loop_Tango_Device_command_list_query_return);

            for (i_Tango_Device_command_list_query_return=0; i_Tango_Device_command_list_query_return < u_octet4_loop_Tango_Device_command_list_query_return; i_Tango_Device_command_list_query_return++) {

                /*  Begin struct "Tango_DevCmdInfo"  */
                decode_Tango_DevCmdInfo_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
                /*  End struct "Tango_DevCmdInfo"  */
            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_tango_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_tango_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:Tango/Device/command_query:1.0
 */
static void
decode_Tango_Device_command_query(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_Device_command_query_command);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /*  Begin struct "Tango_DevCmdInfo"  */
            decode_Tango_DevCmdInfo_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "Tango_DevCmdInfo"  */
            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_tango_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_tango_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:Tango/Device_2/command_inout_2:1.0
 */
static void
decode_Tango_Device_2_command_inout_2(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_Device_2_command_inout_2_command);

        get_CDR_any(tvb, pinfo, tree, item, offset, stream_is_big_endian, boundary, header);

        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        /* coverity[returned_pointer] */
        item = proto_tree_add_uint(tree, hf_Tango_Device_2_command_inout_2_source, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            get_CDR_any(tvb, pinfo, tree, item, offset, stream_is_big_endian, boundary, header);

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_tango_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_tango_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:Tango/Device_2/read_attributes_2:1.0
 */
static void
decode_Tango_Device_2_read_attributes_2(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_Device_2_read_attributes_2_names;
    guint32   i_Tango_Device_2_read_attributes_2_names;
    guint32   u_octet4;
    guint32   u_octet4_loop_Tango_Device_2_read_attributes_2_return;
    guint32   i_Tango_Device_2_read_attributes_2_return;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_Tango_Device_2_read_attributes_2_names = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        /* coverity[returned_pointer] */
        item = proto_tree_add_uint(tree, hf_Tango_Device_2_read_attributes_2_names, tvb,*offset-4, 4, u_octet4_loop_Tango_Device_2_read_attributes_2_names);

        for (i_Tango_Device_2_read_attributes_2_names=0; i_Tango_Device_2_read_attributes_2_names < u_octet4_loop_Tango_Device_2_read_attributes_2_names; i_Tango_Device_2_read_attributes_2_names++) {

            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_Device_2_read_attributes_2_names);

        }

        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        /* coverity[returned_pointer] */
        item = proto_tree_add_uint(tree, hf_Tango_Device_2_read_attributes_2_source, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_Tango_Device_2_read_attributes_2_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            /* coverity[returned_pointer] */
            item = proto_tree_add_uint(tree, hf_Tango_Device_2_read_attributes_2_return, tvb,*offset-4, 4, u_octet4_loop_Tango_Device_2_read_attributes_2_return);

            for (i_Tango_Device_2_read_attributes_2_return=0; i_Tango_Device_2_read_attributes_2_return < u_octet4_loop_Tango_Device_2_read_attributes_2_return; i_Tango_Device_2_read_attributes_2_return++) {

                /*  Begin struct "Tango_AttributeValue"  */
                decode_Tango_AttributeValue_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
                /*  End struct "Tango_AttributeValue"  */
            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_tango_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_tango_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:Tango/Device_2/get_attribute_config_2:1.0
 */
static void
decode_Tango_Device_2_get_attribute_config_2(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_Device_2_get_attribute_config_2_names;
    guint32   i_Tango_Device_2_get_attribute_config_2_names;
    guint32   u_octet4_loop_Tango_Device_2_get_attribute_config_2_return;
    guint32   i_Tango_Device_2_get_attribute_config_2_return;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_Tango_Device_2_get_attribute_config_2_names = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        /* coverity[returned_pointer] */
        item = proto_tree_add_uint(tree, hf_Tango_Device_2_get_attribute_config_2_names, tvb,*offset-4, 4, u_octet4_loop_Tango_Device_2_get_attribute_config_2_names);

        for (i_Tango_Device_2_get_attribute_config_2_names=0; i_Tango_Device_2_get_attribute_config_2_names < u_octet4_loop_Tango_Device_2_get_attribute_config_2_names; i_Tango_Device_2_get_attribute_config_2_names++) {

            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_Device_2_get_attribute_config_2_names);

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_Tango_Device_2_get_attribute_config_2_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            /* coverity[returned_pointer] */
            item = proto_tree_add_uint(tree, hf_Tango_Device_2_get_attribute_config_2_return, tvb,*offset-4, 4, u_octet4_loop_Tango_Device_2_get_attribute_config_2_return);

            for (i_Tango_Device_2_get_attribute_config_2_return=0; i_Tango_Device_2_get_attribute_config_2_return < u_octet4_loop_Tango_Device_2_get_attribute_config_2_return; i_Tango_Device_2_get_attribute_config_2_return++) {

                /*  Begin struct "Tango_AttributeConfig_2"  */
                decode_Tango_AttributeConfig_2_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
                /*  End struct "Tango_AttributeConfig_2"  */
            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_tango_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_tango_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:Tango/Device_2/command_list_query_2:1.0
 */
static void
decode_Tango_Device_2_command_list_query_2(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_Device_2_command_list_query_2_return;
    guint32   i_Tango_Device_2_command_list_query_2_return;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_Tango_Device_2_command_list_query_2_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            /* coverity[returned_pointer] */
            item = proto_tree_add_uint(tree, hf_Tango_Device_2_command_list_query_2_return, tvb,*offset-4, 4, u_octet4_loop_Tango_Device_2_command_list_query_2_return);

            for (i_Tango_Device_2_command_list_query_2_return=0; i_Tango_Device_2_command_list_query_2_return < u_octet4_loop_Tango_Device_2_command_list_query_2_return; i_Tango_Device_2_command_list_query_2_return++) {

                /*  Begin struct "Tango_DevCmdInfo_2"  */
                decode_Tango_DevCmdInfo_2_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
                /*  End struct "Tango_DevCmdInfo_2"  */
            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_tango_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_tango_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:Tango/Device_2/command_query_2:1.0
 */
static void
decode_Tango_Device_2_command_query_2(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_Device_2_command_query_2_command);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /*  Begin struct "Tango_DevCmdInfo_2"  */
            decode_Tango_DevCmdInfo_2_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "Tango_DevCmdInfo_2"  */
            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_tango_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_tango_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:Tango/Device_2/command_inout_history_2:1.0
 */
static void
decode_Tango_Device_2_command_inout_history_2(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_Device_2_command_inout_history_2_return;
    guint32   i_Tango_Device_2_command_inout_history_2_return;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_Device_2_command_inout_history_2_command);

        proto_tree_add_int(tree, hf_Tango_Device_2_command_inout_history_2_n, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_Tango_Device_2_command_inout_history_2_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            /* coverity[returned_pointer] */
            item = proto_tree_add_uint(tree, hf_Tango_Device_2_command_inout_history_2_return, tvb,*offset-4, 4, u_octet4_loop_Tango_Device_2_command_inout_history_2_return);

            for (i_Tango_Device_2_command_inout_history_2_return=0; i_Tango_Device_2_command_inout_history_2_return < u_octet4_loop_Tango_Device_2_command_inout_history_2_return; i_Tango_Device_2_command_inout_history_2_return++) {

                /*  Begin struct "Tango_DevCmdHistory"  */
                decode_Tango_DevCmdHistory_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
                /*  End struct "Tango_DevCmdHistory"  */
            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_tango_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_tango_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:Tango/Device_2/read_attribute_history_2:1.0
 */
static void
decode_Tango_Device_2_read_attribute_history_2(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_Device_2_read_attribute_history_2_return;
    guint32   i_Tango_Device_2_read_attribute_history_2_return;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_Device_2_read_attribute_history_2_name);

        proto_tree_add_int(tree, hf_Tango_Device_2_read_attribute_history_2_n, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_Tango_Device_2_read_attribute_history_2_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            /* coverity[returned_pointer] */
            item = proto_tree_add_uint(tree, hf_Tango_Device_2_read_attribute_history_2_return, tvb,*offset-4, 4, u_octet4_loop_Tango_Device_2_read_attribute_history_2_return);

            for (i_Tango_Device_2_read_attribute_history_2_return=0; i_Tango_Device_2_read_attribute_history_2_return < u_octet4_loop_Tango_Device_2_read_attribute_history_2_return; i_Tango_Device_2_read_attribute_history_2_return++) {

                /*  Begin struct "Tango_DevAttrHistory"  */
                decode_Tango_DevAttrHistory_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
                /*  End struct "Tango_DevAttrHistory"  */
            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_tango_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_tango_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:Tango/Device_3/read_attributes_3:1.0
 */
static void
decode_Tango_Device_3_read_attributes_3(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_Device_3_read_attributes_3_names;
    guint32   i_Tango_Device_3_read_attributes_3_names;
    guint32   u_octet4;
    guint32   u_octet4_loop_Tango_Device_3_read_attributes_3_return;
    guint32   i_Tango_Device_3_read_attributes_3_return;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_Tango_Device_3_read_attributes_3_names = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        /* coverity[returned_pointer] */
        item = proto_tree_add_uint(tree, hf_Tango_Device_3_read_attributes_3_names, tvb,*offset-4, 4, u_octet4_loop_Tango_Device_3_read_attributes_3_names);

        for (i_Tango_Device_3_read_attributes_3_names=0; i_Tango_Device_3_read_attributes_3_names < u_octet4_loop_Tango_Device_3_read_attributes_3_names; i_Tango_Device_3_read_attributes_3_names++) {

            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_Device_3_read_attributes_3_names);

        }

        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        /* coverity[returned_pointer] */
        item = proto_tree_add_uint(tree, hf_Tango_Device_3_read_attributes_3_source, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_Tango_Device_3_read_attributes_3_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            /* coverity[returned_pointer] */
            item = proto_tree_add_uint(tree, hf_Tango_Device_3_read_attributes_3_return, tvb,*offset-4, 4, u_octet4_loop_Tango_Device_3_read_attributes_3_return);

            for (i_Tango_Device_3_read_attributes_3_return=0; i_Tango_Device_3_read_attributes_3_return < u_octet4_loop_Tango_Device_3_read_attributes_3_return; i_Tango_Device_3_read_attributes_3_return++) {

                /*  Begin struct "Tango_AttributeValue_3"  */
                decode_Tango_AttributeValue_3_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
                /*  End struct "Tango_AttributeValue_3"  */
            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_tango_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_tango_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:Tango/Device_3/write_attributes_3:1.0
 */
static void
decode_Tango_Device_3_write_attributes_3(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_Device_3_write_attributes_3_values;
    guint32   i_Tango_Device_3_write_attributes_3_values;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_Tango_Device_3_write_attributes_3_values = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        /* coverity[returned_pointer] */
        item = proto_tree_add_uint(tree, hf_Tango_Device_3_write_attributes_3_values, tvb,*offset-4, 4, u_octet4_loop_Tango_Device_3_write_attributes_3_values);

        for (i_Tango_Device_3_write_attributes_3_values=0; i_Tango_Device_3_write_attributes_3_values < u_octet4_loop_Tango_Device_3_write_attributes_3_values; i_Tango_Device_3_write_attributes_3_values++) {

            /*  Begin struct "Tango_AttributeValue"  */
            decode_Tango_AttributeValue_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "Tango_AttributeValue"  */
        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_tango_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_tango_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:Tango/Device_3/read_attribute_history_3:1.0
 */
static void
decode_Tango_Device_3_read_attribute_history_3(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_Device_3_read_attribute_history_3_return;
    guint32   i_Tango_Device_3_read_attribute_history_3_return;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_Device_3_read_attribute_history_3_name);

        proto_tree_add_int(tree, hf_Tango_Device_3_read_attribute_history_3_n, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_Tango_Device_3_read_attribute_history_3_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            /* coverity[returned_pointer] */
            item = proto_tree_add_uint(tree, hf_Tango_Device_3_read_attribute_history_3_return, tvb,*offset-4, 4, u_octet4_loop_Tango_Device_3_read_attribute_history_3_return);

            for (i_Tango_Device_3_read_attribute_history_3_return=0; i_Tango_Device_3_read_attribute_history_3_return < u_octet4_loop_Tango_Device_3_read_attribute_history_3_return; i_Tango_Device_3_read_attribute_history_3_return++) {

                /*  Begin struct "Tango_DevAttrHistory_3"  */
                decode_Tango_DevAttrHistory_3_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
                /*  End struct "Tango_DevAttrHistory_3"  */
            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_tango_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_tango_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:Tango/Device_3/info_3:1.0
 */
static void
decode_Tango_Device_3_info_3(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /*  Begin struct "Tango_DevInfo_3"  */
            decode_Tango_DevInfo_3_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "Tango_DevInfo_3"  */
            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_tango_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_tango_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:Tango/Device_3/get_attribute_config_3:1.0
 */
static void
decode_Tango_Device_3_get_attribute_config_3(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_Device_3_get_attribute_config_3_names;
    guint32   i_Tango_Device_3_get_attribute_config_3_names;
    guint32   u_octet4_loop_Tango_Device_3_get_attribute_config_3_return;
    guint32   i_Tango_Device_3_get_attribute_config_3_return;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_Tango_Device_3_get_attribute_config_3_names = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        /* coverity[returned_pointer] */
        item = proto_tree_add_uint(tree, hf_Tango_Device_3_get_attribute_config_3_names, tvb,*offset-4, 4, u_octet4_loop_Tango_Device_3_get_attribute_config_3_names);

        for (i_Tango_Device_3_get_attribute_config_3_names=0; i_Tango_Device_3_get_attribute_config_3_names < u_octet4_loop_Tango_Device_3_get_attribute_config_3_names; i_Tango_Device_3_get_attribute_config_3_names++) {

            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_Device_3_get_attribute_config_3_names);

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_Tango_Device_3_get_attribute_config_3_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            /* coverity[returned_pointer] */
            item = proto_tree_add_uint(tree, hf_Tango_Device_3_get_attribute_config_3_return, tvb,*offset-4, 4, u_octet4_loop_Tango_Device_3_get_attribute_config_3_return);

            for (i_Tango_Device_3_get_attribute_config_3_return=0; i_Tango_Device_3_get_attribute_config_3_return < u_octet4_loop_Tango_Device_3_get_attribute_config_3_return; i_Tango_Device_3_get_attribute_config_3_return++) {

                /*  Begin struct "Tango_AttributeConfig_3"  */
                decode_Tango_AttributeConfig_3_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
                /*  End struct "Tango_AttributeConfig_3"  */
            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_tango_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_tango_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:Tango/Device_3/set_attribute_config_3:1.0
 */
static void
decode_Tango_Device_3_set_attribute_config_3(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_Device_3_set_attribute_config_3_new_conf;
    guint32   i_Tango_Device_3_set_attribute_config_3_new_conf;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_Tango_Device_3_set_attribute_config_3_new_conf = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        /* coverity[returned_pointer] */
        item = proto_tree_add_uint(tree, hf_Tango_Device_3_set_attribute_config_3_new_conf, tvb,*offset-4, 4, u_octet4_loop_Tango_Device_3_set_attribute_config_3_new_conf);

        for (i_Tango_Device_3_set_attribute_config_3_new_conf=0; i_Tango_Device_3_set_attribute_config_3_new_conf < u_octet4_loop_Tango_Device_3_set_attribute_config_3_new_conf; i_Tango_Device_3_set_attribute_config_3_new_conf++) {

            /*  Begin struct "Tango_AttributeConfig_3"  */
            decode_Tango_AttributeConfig_3_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "Tango_AttributeConfig_3"  */
        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_tango_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_tango_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/* Struct = IDL:Tango/DevVarLongStringArray:1.0 */
static void
decode_Tango_DevVarLongStringArray_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{

    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_DevVarLongStringArray_lvalue;
    guint32   i_Tango_DevVarLongStringArray_lvalue;
    guint32   u_octet4_loop_Tango_DevVarLongStringArray_svalue;
    guint32   i_Tango_DevVarLongStringArray_svalue;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    u_octet4_loop_Tango_DevVarLongStringArray_lvalue = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_DevVarLongStringArray_lvalue, tvb,*offset-4, 4, u_octet4_loop_Tango_DevVarLongStringArray_lvalue);

    for (i_Tango_DevVarLongStringArray_lvalue=0; i_Tango_DevVarLongStringArray_lvalue < u_octet4_loop_Tango_DevVarLongStringArray_lvalue; i_Tango_DevVarLongStringArray_lvalue++) {

        proto_tree_add_int(tree, hf_Tango_DevVarLongStringArray_lvalue, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

    }

    u_octet4_loop_Tango_DevVarLongStringArray_svalue = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_DevVarLongStringArray_svalue, tvb,*offset-4, 4, u_octet4_loop_Tango_DevVarLongStringArray_svalue);

    for (i_Tango_DevVarLongStringArray_svalue=0; i_Tango_DevVarLongStringArray_svalue < u_octet4_loop_Tango_DevVarLongStringArray_svalue; i_Tango_DevVarLongStringArray_svalue++) {

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_DevVarLongStringArray_svalue);

    }

}

/* Struct = IDL:Tango/DevVarDoubleStringArray:1.0 */
static void
decode_Tango_DevVarDoubleStringArray_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{

    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_DevVarDoubleStringArray_dvalue;
    guint32   i_Tango_DevVarDoubleStringArray_dvalue;
    guint32   u_octet4_loop_Tango_DevVarDoubleStringArray_svalue;
    guint32   i_Tango_DevVarDoubleStringArray_svalue;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    u_octet4_loop_Tango_DevVarDoubleStringArray_dvalue = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_DevVarDoubleStringArray_dvalue, tvb,*offset-4, 4, u_octet4_loop_Tango_DevVarDoubleStringArray_dvalue);

    for (i_Tango_DevVarDoubleStringArray_dvalue=0; i_Tango_DevVarDoubleStringArray_dvalue < u_octet4_loop_Tango_DevVarDoubleStringArray_dvalue; i_Tango_DevVarDoubleStringArray_dvalue++) {

        proto_tree_add_double(tree, hf_Tango_DevVarDoubleStringArray_dvalue, tvb, *offset-8, 8, get_CDR_double(tvb,offset,stream_is_big_endian, boundary));

    }

    u_octet4_loop_Tango_DevVarDoubleStringArray_svalue = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_DevVarDoubleStringArray_svalue, tvb,*offset-4, 4, u_octet4_loop_Tango_DevVarDoubleStringArray_svalue);

    for (i_Tango_DevVarDoubleStringArray_svalue=0; i_Tango_DevVarDoubleStringArray_svalue < u_octet4_loop_Tango_DevVarDoubleStringArray_svalue; i_Tango_DevVarDoubleStringArray_svalue++) {

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_DevVarDoubleStringArray_svalue);

    }

}

/* Struct = IDL:Tango/TimeVal:1.0 */
static void
decode_Tango_TimeVal_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{

    proto_tree_add_int(tree, hf_Tango_TimeVal_tv_sec, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

    proto_tree_add_int(tree, hf_Tango_TimeVal_tv_usec, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

    proto_tree_add_int(tree, hf_Tango_TimeVal_tv_nsec, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

}

/* Struct = IDL:Tango/DevCmdInfo:1.0 */
static void
decode_Tango_DevCmdInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_DevCmdInfo_cmd_name);

    proto_tree_add_int(tree, hf_Tango_DevCmdInfo_cmd_tag, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

    proto_tree_add_int(tree, hf_Tango_DevCmdInfo_in_type, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

    proto_tree_add_int(tree, hf_Tango_DevCmdInfo_out_type, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_DevCmdInfo_in_type_desc);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_DevCmdInfo_out_type_desc);

}

/* Struct = IDL:Tango/DevCmdInfo_2:1.0 */
static void
decode_Tango_DevCmdInfo_2_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{

    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_DevCmdInfo_2_cmd_name);

    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_DevCmdInfo_2_level, tvb, *offset-4, 4, u_octet4);

    proto_tree_add_int(tree, hf_Tango_DevCmdInfo_2_cmd_tag, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

    proto_tree_add_int(tree, hf_Tango_DevCmdInfo_2_in_type, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

    proto_tree_add_int(tree, hf_Tango_DevCmdInfo_2_out_type, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_DevCmdInfo_2_in_type_desc);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_DevCmdInfo_2_out_type_desc);

}

/* Struct = IDL:Tango/DevError:1.0 */
static void
decode_Tango_DevError_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{

    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_DevError_reason);

    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_DevError_severity, tvb, *offset-4, 4, u_octet4);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_DevError_desc);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_DevError_origin);

}

/* Struct = IDL:Tango/NamedDevError:1.0 */
static void
decode_Tango_NamedDevError_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{

    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_NamedDevError_err_list;
    guint32   i_Tango_NamedDevError_err_list;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_NamedDevError_name);

    proto_tree_add_int(tree, hf_Tango_NamedDevError_index_in_call, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

    u_octet4_loop_Tango_NamedDevError_err_list = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_NamedDevError_err_list, tvb,*offset-4, 4, u_octet4_loop_Tango_NamedDevError_err_list);

    for (i_Tango_NamedDevError_err_list=0; i_Tango_NamedDevError_err_list < u_octet4_loop_Tango_NamedDevError_err_list; i_Tango_NamedDevError_err_list++) {

        /*  Begin struct "Tango_DevError"  */
        decode_Tango_DevError_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "Tango_DevError"  */
    }

}

/* Struct = IDL:Tango/AttributeConfig:1.0 */
static void
decode_Tango_AttributeConfig_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{

    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    guint32   u_octet4_loop_Tango_AttributeConfig_extensions;
    guint32   i_Tango_AttributeConfig_extensions;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_name);

    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_AttributeConfig_writable, tvb, *offset-4, 4, u_octet4);

    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_AttributeConfig_data_format, tvb, *offset-4, 4, u_octet4);

    proto_tree_add_int(tree, hf_Tango_AttributeConfig_data_type, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

    proto_tree_add_int(tree, hf_Tango_AttributeConfig_max_dim_x, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

    proto_tree_add_int(tree, hf_Tango_AttributeConfig_max_dim_y, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_description);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_label);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_unit);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_standard_unit);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_display_unit);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_format);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_min_value);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_max_value);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_min_alarm);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_max_alarm);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_writable_attr_name);

    u_octet4_loop_Tango_AttributeConfig_extensions = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_AttributeConfig_extensions, tvb,*offset-4, 4, u_octet4_loop_Tango_AttributeConfig_extensions);

    for (i_Tango_AttributeConfig_extensions=0; i_Tango_AttributeConfig_extensions < u_octet4_loop_Tango_AttributeConfig_extensions; i_Tango_AttributeConfig_extensions++) {

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_extensions);

    }

}

/* Struct = IDL:Tango/AttributeConfig_2:1.0 */
static void
decode_Tango_AttributeConfig_2_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{

    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    guint32   u_octet4_loop_Tango_AttributeConfig_2_extensions;
    guint32   i_Tango_AttributeConfig_2_extensions;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_2_name);

    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_AttributeConfig_2_writable, tvb, *offset-4, 4, u_octet4);

    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_AttributeConfig_2_data_format, tvb, *offset-4, 4, u_octet4);

    proto_tree_add_int(tree, hf_Tango_AttributeConfig_2_data_type, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

    proto_tree_add_int(tree, hf_Tango_AttributeConfig_2_max_dim_x, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

    proto_tree_add_int(tree, hf_Tango_AttributeConfig_2_max_dim_y, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_2_description);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_2_label);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_2_unit);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_2_standard_unit);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_2_display_unit);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_2_format);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_2_min_value);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_2_max_value);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_2_min_alarm);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_2_max_alarm);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_2_writable_attr_name);

    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_AttributeConfig_2_level, tvb, *offset-4, 4, u_octet4);

    u_octet4_loop_Tango_AttributeConfig_2_extensions = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_AttributeConfig_2_extensions, tvb,*offset-4, 4, u_octet4_loop_Tango_AttributeConfig_2_extensions);

    for (i_Tango_AttributeConfig_2_extensions=0; i_Tango_AttributeConfig_2_extensions < u_octet4_loop_Tango_AttributeConfig_2_extensions; i_Tango_AttributeConfig_2_extensions++) {

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_2_extensions);

    }

}

/* Struct = IDL:Tango/AttributeValue:1.0 */
static void
decode_Tango_AttributeValue_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{

    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    get_CDR_any(tvb, pinfo, tree, item, offset, stream_is_big_endian, boundary, header);

    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_AttributeValue_quality, tvb, *offset-4, 4, u_octet4);

    /*  Begin struct "Tango_TimeVal"  */
    decode_Tango_TimeVal_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
    /*  End struct "Tango_TimeVal"  */
    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeValue_name);

    proto_tree_add_int(tree, hf_Tango_AttributeValue_dim_x, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

    proto_tree_add_int(tree, hf_Tango_AttributeValue_dim_y, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

}

/* Struct = IDL:Tango/AttributeDim:1.0 */
static void
decode_Tango_AttributeDim_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{

    proto_tree_add_int(tree, hf_Tango_AttributeDim_dim_x, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

    proto_tree_add_int(tree, hf_Tango_AttributeDim_dim_y, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

}

/* Struct = IDL:Tango/AttributeValue_3:1.0 */
static void
decode_Tango_AttributeValue_3_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{

    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    guint32   u_octet4_loop_Tango_AttributeValue_3_err_list;
    guint32   i_Tango_AttributeValue_3_err_list;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    get_CDR_any(tvb, pinfo, tree, item, offset, stream_is_big_endian, boundary, header);

    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_AttributeValue_3_quality, tvb, *offset-4, 4, u_octet4);

    /*  Begin struct "Tango_TimeVal"  */
    decode_Tango_TimeVal_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
    /*  End struct "Tango_TimeVal"  */
    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeValue_3_name);

    /*  Begin struct "Tango_AttributeDim"  */
    decode_Tango_AttributeDim_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
    /*  End struct "Tango_AttributeDim"  */
    /*  Begin struct "Tango_AttributeDim"  */
    decode_Tango_AttributeDim_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
    /*  End struct "Tango_AttributeDim"  */
    u_octet4_loop_Tango_AttributeValue_3_err_list = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_AttributeValue_3_err_list, tvb,*offset-4, 4, u_octet4_loop_Tango_AttributeValue_3_err_list);

    for (i_Tango_AttributeValue_3_err_list=0; i_Tango_AttributeValue_3_err_list < u_octet4_loop_Tango_AttributeValue_3_err_list; i_Tango_AttributeValue_3_err_list++) {

        /*  Begin struct "Tango_DevError"  */
        decode_Tango_DevError_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "Tango_DevError"  */
    }

}

/* Struct = IDL:Tango/ChangeEventProp:1.0 */
static void
decode_Tango_ChangeEventProp_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{

    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_ChangeEventProp_extensions;
    guint32   i_Tango_ChangeEventProp_extensions;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_ChangeEventProp_rel_change);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_ChangeEventProp_abs_change);

    u_octet4_loop_Tango_ChangeEventProp_extensions = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_ChangeEventProp_extensions, tvb,*offset-4, 4, u_octet4_loop_Tango_ChangeEventProp_extensions);

    for (i_Tango_ChangeEventProp_extensions=0; i_Tango_ChangeEventProp_extensions < u_octet4_loop_Tango_ChangeEventProp_extensions; i_Tango_ChangeEventProp_extensions++) {

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_ChangeEventProp_extensions);

    }

}

/* Struct = IDL:Tango/PeriodicEventProp:1.0 */
static void
decode_Tango_PeriodicEventProp_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{

    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_PeriodicEventProp_extensions;
    guint32   i_Tango_PeriodicEventProp_extensions;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_PeriodicEventProp_period);

    u_octet4_loop_Tango_PeriodicEventProp_extensions = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_PeriodicEventProp_extensions, tvb,*offset-4, 4, u_octet4_loop_Tango_PeriodicEventProp_extensions);

    for (i_Tango_PeriodicEventProp_extensions=0; i_Tango_PeriodicEventProp_extensions < u_octet4_loop_Tango_PeriodicEventProp_extensions; i_Tango_PeriodicEventProp_extensions++) {

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_PeriodicEventProp_extensions);

    }

}

/* Struct = IDL:Tango/ArchiveEventProp:1.0 */
static void
decode_Tango_ArchiveEventProp_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{

    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_ArchiveEventProp_extensions;
    guint32   i_Tango_ArchiveEventProp_extensions;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_ArchiveEventProp_rel_change);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_ArchiveEventProp_abs_change);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_ArchiveEventProp_period);

    u_octet4_loop_Tango_ArchiveEventProp_extensions = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_ArchiveEventProp_extensions, tvb,*offset-4, 4, u_octet4_loop_Tango_ArchiveEventProp_extensions);

    for (i_Tango_ArchiveEventProp_extensions=0; i_Tango_ArchiveEventProp_extensions < u_octet4_loop_Tango_ArchiveEventProp_extensions; i_Tango_ArchiveEventProp_extensions++) {

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_ArchiveEventProp_extensions);

    }

}

/* Struct = IDL:Tango/EventProperties:1.0 */
static void
decode_Tango_EventProperties_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{

    /*  Begin struct "Tango_ChangeEventProp"  */
    decode_Tango_ChangeEventProp_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
    /*  End struct "Tango_ChangeEventProp"  */
    /*  Begin struct "Tango_PeriodicEventProp"  */
    decode_Tango_PeriodicEventProp_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
    /*  End struct "Tango_PeriodicEventProp"  */
    /*  Begin struct "Tango_ArchiveEventProp"  */
    decode_Tango_ArchiveEventProp_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
    /*  End struct "Tango_ArchiveEventProp"  */
}

/* Struct = IDL:Tango/AttributeAlarm:1.0 */
static void
decode_Tango_AttributeAlarm_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{

    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_AttributeAlarm_extensions;
    guint32   i_Tango_AttributeAlarm_extensions;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeAlarm_min_alarm);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeAlarm_max_alarm);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeAlarm_min_warning);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeAlarm_max_warning);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeAlarm_delta_t);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeAlarm_delta_val);

    u_octet4_loop_Tango_AttributeAlarm_extensions = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_AttributeAlarm_extensions, tvb,*offset-4, 4, u_octet4_loop_Tango_AttributeAlarm_extensions);

    for (i_Tango_AttributeAlarm_extensions=0; i_Tango_AttributeAlarm_extensions < u_octet4_loop_Tango_AttributeAlarm_extensions; i_Tango_AttributeAlarm_extensions++) {

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeAlarm_extensions);

    }

}

/* Struct = IDL:Tango/AttributeConfig_3:1.0 */
static void
decode_Tango_AttributeConfig_3_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{

    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    guint32   u_octet4_loop_Tango_AttributeConfig_3_extensions;
    guint32   i_Tango_AttributeConfig_3_extensions;
    guint32   u_octet4_loop_Tango_AttributeConfig_3_sys_extensions;
    guint32   i_Tango_AttributeConfig_3_sys_extensions;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_3_name);

    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_AttributeConfig_3_writable, tvb, *offset-4, 4, u_octet4);

    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_AttributeConfig_3_data_format, tvb, *offset-4, 4, u_octet4);

    proto_tree_add_int(tree, hf_Tango_AttributeConfig_3_data_type, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

    proto_tree_add_int(tree, hf_Tango_AttributeConfig_3_max_dim_x, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

    proto_tree_add_int(tree, hf_Tango_AttributeConfig_3_max_dim_y, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_3_description);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_3_label);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_3_unit);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_3_standard_unit);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_3_display_unit);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_3_format);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_3_min_value);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_3_max_value);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_3_writable_attr_name);

    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_AttributeConfig_3_level, tvb, *offset-4, 4, u_octet4);

    /*  Begin struct "Tango_AttributeAlarm"  */
    decode_Tango_AttributeAlarm_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
    /*  End struct "Tango_AttributeAlarm"  */
    /*  Begin struct "Tango_EventProperties"  */
    decode_Tango_EventProperties_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
    /*  End struct "Tango_EventProperties"  */
    u_octet4_loop_Tango_AttributeConfig_3_extensions = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_AttributeConfig_3_extensions, tvb,*offset-4, 4, u_octet4_loop_Tango_AttributeConfig_3_extensions);

    for (i_Tango_AttributeConfig_3_extensions=0; i_Tango_AttributeConfig_3_extensions < u_octet4_loop_Tango_AttributeConfig_3_extensions; i_Tango_AttributeConfig_3_extensions++) {

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_3_extensions);

    }

    u_octet4_loop_Tango_AttributeConfig_3_sys_extensions = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_AttributeConfig_3_sys_extensions, tvb,*offset-4, 4, u_octet4_loop_Tango_AttributeConfig_3_sys_extensions);

    for (i_Tango_AttributeConfig_3_sys_extensions=0; i_Tango_AttributeConfig_3_sys_extensions < u_octet4_loop_Tango_AttributeConfig_3_sys_extensions; i_Tango_AttributeConfig_3_sys_extensions++) {

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_AttributeConfig_3_sys_extensions);

    }

}

/* Struct = IDL:Tango/DevInfo:1.0 */
static void
decode_Tango_DevInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_DevInfo_dev_class);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_DevInfo_server_id);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_DevInfo_server_host);

    proto_tree_add_int(tree, hf_Tango_DevInfo_server_version, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_DevInfo_doc_url);

}

/* Struct = IDL:Tango/DevInfo_3:1.0 */
static void
decode_Tango_DevInfo_3_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_DevInfo_3_dev_class);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_DevInfo_3_server_id);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_DevInfo_3_server_host);

    proto_tree_add_int(tree, hf_Tango_DevInfo_3_server_version, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_DevInfo_3_doc_url);

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_Tango_DevInfo_3_dev_type);

}

/* Struct = IDL:Tango/DevCmdHistory:1.0 */
static void
decode_Tango_DevCmdHistory_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{

    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_DevCmdHistory_errors;
    guint32   i_Tango_DevCmdHistory_errors;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    /*  Begin struct "Tango_TimeVal"  */
    decode_Tango_TimeVal_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
    /*  End struct "Tango_TimeVal"  */
    proto_tree_add_boolean(tree, hf_Tango_DevCmdHistory_cmd_failed, tvb, *offset-1, 1, get_CDR_boolean(tvb,offset));

    get_CDR_any(tvb, pinfo, tree, item, offset, stream_is_big_endian, boundary, header);

    u_octet4_loop_Tango_DevCmdHistory_errors = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_DevCmdHistory_errors, tvb,*offset-4, 4, u_octet4_loop_Tango_DevCmdHistory_errors);

    for (i_Tango_DevCmdHistory_errors=0; i_Tango_DevCmdHistory_errors < u_octet4_loop_Tango_DevCmdHistory_errors; i_Tango_DevCmdHistory_errors++) {

        /*  Begin struct "Tango_DevError"  */
        decode_Tango_DevError_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "Tango_DevError"  */
    }

}

/* Struct = IDL:Tango/DevAttrHistory:1.0 */
static void
decode_Tango_DevAttrHistory_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{

    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_Tango_DevAttrHistory_errors;
    guint32   i_Tango_DevAttrHistory_errors;
    /* Operation specific Variable declarations End */

    (void)item; /* Avoid coverity param_set_but_unused parse warning */

    proto_tree_add_boolean(tree, hf_Tango_DevAttrHistory_attr_failed, tvb, *offset-1, 1, get_CDR_boolean(tvb,offset));

    /*  Begin struct "Tango_AttributeValue"  */
    decode_Tango_AttributeValue_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
    /*  End struct "Tango_AttributeValue"  */
    u_octet4_loop_Tango_DevAttrHistory_errors = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    /* coverity[returned_pointer] */
    item = proto_tree_add_uint(tree, hf_Tango_DevAttrHistory_errors, tvb,*offset-4, 4, u_octet4_loop_Tango_DevAttrHistory_errors);

    for (i_Tango_DevAttrHistory_errors=0; i_Tango_DevAttrHistory_errors < u_octet4_loop_Tango_DevAttrHistory_errors; i_Tango_DevAttrHistory_errors++) {

        /*  Begin struct "Tango_DevError"  */
        decode_Tango_DevError_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "Tango_DevError"  */
    }

}

/* Struct = IDL:Tango/DevAttrHistory_3:1.0 */
static void
decode_Tango_DevAttrHistory_3_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{

    proto_tree_add_boolean(tree, hf_Tango_DevAttrHistory_3_attr_failed, tvb, *offset-1, 1, get_CDR_boolean(tvb,offset));

    /*  Begin struct "Tango_AttributeValue_3"  */
    decode_Tango_AttributeValue_3_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
    /*  End struct "Tango_AttributeValue_3"  */
}

/*
 * Called once we accept the packet as being for us; it sets the
 * Protocol and Info columns and creates the top-level protocol
 * tree item.
 */
static proto_tree *
start_dissecting(tvbuff_t *tvb, packet_info *pinfo, proto_tree *ptree, int *offset)
{

    proto_item *ti = NULL;
    proto_tree *tree = NULL;            /* init later, inside if(tree) */

    col_set_str(pinfo->cinfo, COL_PROTOCOL, "TANGO");

    /*
     * Do not clear COL_INFO, as nothing is being written there by
     * this dissector yet. So leave it as is from the GIOP dissector.
     * TODO: add something useful to COL_INFO
     *     col_clear(pinfo->cinfo, COL_INFO);
     */

    if (ptree) {
        ti = proto_tree_add_item(ptree, proto_tango, tvb, *offset, -1, ENC_NA);
        tree = proto_item_add_subtree(ti, ett_tango);
    }
    return tree;
}

static proto_item*
process_RequestOperation(tvbuff_t *tvb, packet_info *pinfo, proto_tree *ptree, MessageHeader *header, const gchar *operation)
{
    proto_item *pi;
    if(header->message_type == Reply) {
        /* fill-up info column */
        col_append_fstr(pinfo->cinfo, COL_INFO, " op = %s",operation);
    }
    /* fill-up the field */
    pi=proto_tree_add_string(ptree, hf_operationrequest, tvb, 0, 0, operation);
    PROTO_ITEM_SET_GENERATED(pi);
    return pi;
}

static gboolean
dissect_tango(tvbuff_t *tvb, packet_info *pinfo, proto_tree *ptree, int *offset, MessageHeader *header, const gchar *operation, gchar *idlname)
{
    proto_item *item _U_;
    proto_tree *tree _U_;
    gboolean stream_is_big_endian = is_big_endian(header); /* get endianess */

    /* If we have a USER Exception, then decode it and return */
    if ((header->message_type == Reply) && (header->rep_status == USER_EXCEPTION)) {
       return decode_user_exception(tvb, pinfo, ptree, offset, header, operation, stream_is_big_endian);
    }

    switch(header->message_type) {

    case Request:
    case Reply:

        if (strcmp(operation, "command_inout") == 0
            && (!idlname || strcmp(idlname, "Tango/Device") == 0)) {
           item = process_RequestOperation(tvb, pinfo, ptree, header, operation);  /* fill-up Request_Operation field & info column */
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_command_inout(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, "get_attribute_config") == 0
            && (!idlname || strcmp(idlname, "Tango/Device") == 0)) {
           item = process_RequestOperation(tvb, pinfo, ptree, header, operation);  /* fill-up Request_Operation field & info column */
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_get_attribute_config(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, "set_attribute_config") == 0
            && (!idlname || strcmp(idlname, "Tango/Device") == 0)) {
           item = process_RequestOperation(tvb, pinfo, ptree, header, operation);  /* fill-up Request_Operation field & info column */
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_set_attribute_config(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, "read_attributes") == 0
            && (!idlname || strcmp(idlname, "Tango/Device") == 0)) {
           item = process_RequestOperation(tvb, pinfo, ptree, header, operation);  /* fill-up Request_Operation field & info column */
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_read_attributes(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, "write_attributes") == 0
            && (!idlname || strcmp(idlname, "Tango/Device") == 0)) {
           item = process_RequestOperation(tvb, pinfo, ptree, header, operation);  /* fill-up Request_Operation field & info column */
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_write_attributes(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, "ping") == 0
            && (!idlname || strcmp(idlname, "Tango/Device") == 0)) {
           item = process_RequestOperation(tvb, pinfo, ptree, header, operation);  /* fill-up Request_Operation field & info column */
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_ping(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, "black_box") == 0
            && (!idlname || strcmp(idlname, "Tango/Device") == 0)) {
           item = process_RequestOperation(tvb, pinfo, ptree, header, operation);  /* fill-up Request_Operation field & info column */
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_black_box(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, "info") == 0
            && (!idlname || strcmp(idlname, "Tango/Device") == 0)) {
           item = process_RequestOperation(tvb, pinfo, ptree, header, operation);  /* fill-up Request_Operation field & info column */
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_info(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, "command_list_query") == 0
            && (!idlname || strcmp(idlname, "Tango/Device") == 0)) {
           item = process_RequestOperation(tvb, pinfo, ptree, header, operation);  /* fill-up Request_Operation field & info column */
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_command_list_query(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, "command_query") == 0
            && (!idlname || strcmp(idlname, "Tango/Device") == 0)) {
           item = process_RequestOperation(tvb, pinfo, ptree, header, operation);  /* fill-up Request_Operation field & info column */
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_command_query(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, "command_inout_2") == 0
            && (!idlname || strcmp(idlname, "Tango/Device_2") == 0)) {
           item = process_RequestOperation(tvb, pinfo, ptree, header, operation);  /* fill-up Request_Operation field & info column */
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_2_command_inout_2(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, "read_attributes_2") == 0
            && (!idlname || strcmp(idlname, "Tango/Device_2") == 0)) {
           item = process_RequestOperation(tvb, pinfo, ptree, header, operation);  /* fill-up Request_Operation field & info column */
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_2_read_attributes_2(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, "get_attribute_config_2") == 0
            && (!idlname || strcmp(idlname, "Tango/Device_2") == 0)) {
           item = process_RequestOperation(tvb, pinfo, ptree, header, operation);  /* fill-up Request_Operation field & info column */
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_2_get_attribute_config_2(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, "command_list_query_2") == 0
            && (!idlname || strcmp(idlname, "Tango/Device_2") == 0)) {
           item = process_RequestOperation(tvb, pinfo, ptree, header, operation);  /* fill-up Request_Operation field & info column */
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_2_command_list_query_2(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, "command_query_2") == 0
            && (!idlname || strcmp(idlname, "Tango/Device_2") == 0)) {
           item = process_RequestOperation(tvb, pinfo, ptree, header, operation);  /* fill-up Request_Operation field & info column */
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_2_command_query_2(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, "command_inout_history_2") == 0
            && (!idlname || strcmp(idlname, "Tango/Device_2") == 0)) {
           item = process_RequestOperation(tvb, pinfo, ptree, header, operation);  /* fill-up Request_Operation field & info column */
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_2_command_inout_history_2(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, "read_attribute_history_2") == 0
            && (!idlname || strcmp(idlname, "Tango/Device_2") == 0)) {
           item = process_RequestOperation(tvb, pinfo, ptree, header, operation);  /* fill-up Request_Operation field & info column */
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_2_read_attribute_history_2(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, "read_attributes_3") == 0
            && (!idlname || strcmp(idlname, "Tango/Device_3") == 0)) {
           item = process_RequestOperation(tvb, pinfo, ptree, header, operation);  /* fill-up Request_Operation field & info column */
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_3_read_attributes_3(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, "write_attributes_3") == 0
            && (!idlname || strcmp(idlname, "Tango/Device_3") == 0)) {
           item = process_RequestOperation(tvb, pinfo, ptree, header, operation);  /* fill-up Request_Operation field & info column */
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_3_write_attributes_3(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, "read_attribute_history_3") == 0
            && (!idlname || strcmp(idlname, "Tango/Device_3") == 0)) {
           item = process_RequestOperation(tvb, pinfo, ptree, header, operation);  /* fill-up Request_Operation field & info column */
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_3_read_attribute_history_3(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, "info_3") == 0
            && (!idlname || strcmp(idlname, "Tango/Device_3") == 0)) {
           item = process_RequestOperation(tvb, pinfo, ptree, header, operation);  /* fill-up Request_Operation field & info column */
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_3_info_3(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, "get_attribute_config_3") == 0
            && (!idlname || strcmp(idlname, "Tango/Device_3") == 0)) {
           item = process_RequestOperation(tvb, pinfo, ptree, header, operation);  /* fill-up Request_Operation field & info column */
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_3_get_attribute_config_3(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, "set_attribute_config_3") == 0
            && (!idlname || strcmp(idlname, "Tango/Device_3") == 0)) {
           item = process_RequestOperation(tvb, pinfo, ptree, header, operation);  /* fill-up Request_Operation field & info column */
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_3_set_attribute_config_3(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, get_Tango_Device_name_at) == 0 && (header->message_type == Reply) && (header->rep_status == NO_EXCEPTION) ) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_get_Tango_Device_name_at(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, get_Tango_Device_description_at) == 0 && (header->message_type == Reply) && (header->rep_status == NO_EXCEPTION) ) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_get_Tango_Device_description_at(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, get_Tango_Device_state_at) == 0 && (header->message_type == Reply) && (header->rep_status == NO_EXCEPTION) ) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_get_Tango_Device_state_at(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, get_Tango_Device_status_at) == 0 && (header->message_type == Reply) && (header->rep_status == NO_EXCEPTION) ) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_get_Tango_Device_status_at(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        if (strcmp(operation, get_Tango_Device_adm_name_at) == 0 && (header->message_type == Reply) && (header->rep_status == NO_EXCEPTION) ) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_get_Tango_Device_adm_name_at(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);
           return TRUE;
        }

        break;

    case CancelRequest:
    case LocateRequest:
    case LocateReply:
    case CloseConnection:
    case MessageError:
    case Fragment:
       return FALSE;      /* not handled yet */

    default:
       return FALSE;      /* not handled yet */

    }   /* switch */


    return FALSE;

}  /* End of main dissector  */


/* Register the protocol with Wireshark */
void proto_register_giop_tango(void)
{
   /* setup list of header fields */
   static hf_register_info hf[] = {
        /* field that indicates the currently ongoing request/reply exchange */
		{&hf_operationrequest, {"Request_Operation","giop-tango.Request_Operation",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        /* Operation filters */
        {&hf_Tango_Device_command_inout_command, {"command","giop-tango.Device.command_inout.command",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_get_attribute_config_return, {"Seq length of AttributeConfigList","giop-tango.Device.get_attribute_config.return",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_get_attribute_config_names, {"Seq length of names","giop-tango.Device.get_attribute_config.names",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_set_attribute_config_new_conf, {"Seq length of new_conf","giop-tango.Device.set_attribute_config.new_conf",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_read_attributes_return, {"Seq length of AttributeValueList","giop-tango.Device.read_attributes.return",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_read_attributes_names, {"Seq length of names","giop-tango.Device.read_attributes.names",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_write_attributes_values, {"Seq length of values","giop-tango.Device.write_attributes.values",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_black_box_return, {"Seq length of DevVarStringArray","giop-tango.Device.black_box.return",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_black_box_n, {"n","giop-tango.Device.black_box.n",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_command_list_query_return, {"Seq length of DevCmdInfoList","giop-tango.Device.command_list_query.return",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_command_query_command, {"command","giop-tango.Device.command_query.command",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_2_command_inout_2_command, {"command","giop-tango.Device.command_inout_2.command",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_2_command_inout_2_source, {"source","giop-tango.Device.command_inout_2.source",FT_UINT32,BASE_DEC,VALS(Tango_DevSource),0x0,NULL,HFILL}},
        {&hf_Tango_Device_2_read_attributes_2_return, {"Seq length of AttributeValueList","giop-tango.Device.read_attributes_2.return",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_2_read_attributes_2_names, {"Seq length of names","giop-tango.Device.read_attributes_2.names",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_2_read_attributes_2_source, {"source","giop-tango.Device.read_attributes_2.source",FT_UINT32,BASE_DEC,VALS(Tango_DevSource),0x0,NULL,HFILL}},
        {&hf_Tango_Device_2_get_attribute_config_2_return, {"Seq length of AttributeConfigList_2","giop-tango.Device.get_attribute_config_2.return",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_2_get_attribute_config_2_names, {"Seq length of names","giop-tango.Device.get_attribute_config_2.names",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_2_command_list_query_2_return, {"Seq length of DevCmdInfoList_2","giop-tango.Device.command_list_query_2.return",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_2_command_query_2_command, {"command","giop-tango.Device.command_query_2.command",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_2_command_inout_history_2_return, {"Seq length of DevCmdHistoryList","giop-tango.Device.command_inout_history_2.return",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_2_command_inout_history_2_command, {"command","giop-tango.Device.command_inout_history_2.command",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_2_command_inout_history_2_n, {"n","giop-tango.Device.command_inout_history_2.n",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_2_read_attribute_history_2_return, {"Seq length of DevAttrHistoryList","giop-tango.Device.read_attribute_history_2.return",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_2_read_attribute_history_2_name, {"name","giop-tango.Device.read_attribute_history_2.name",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_2_read_attribute_history_2_n, {"n","giop-tango.Device.read_attribute_history_2.n",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_3_read_attributes_3_return, {"Seq length of AttributeValueList_3","giop-tango.Device.read_attributes_3.return",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_3_read_attributes_3_names, {"Seq length of names","giop-tango.Device.read_attributes_3.names",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_3_read_attributes_3_source, {"source","giop-tango.Device.read_attributes_3.source",FT_UINT32,BASE_DEC,VALS(Tango_DevSource),0x0,NULL,HFILL}},
        {&hf_Tango_Device_3_write_attributes_3_values, {"Seq length of values","giop-tango.Device.write_attributes_3.values",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_3_read_attribute_history_3_return, {"Seq length of DevAttrHistoryList_3","giop-tango.Device.read_attribute_history_3.return",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_3_read_attribute_history_3_name, {"name","giop-tango.Device.read_attribute_history_3.name",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_3_read_attribute_history_3_n, {"n","giop-tango.Device.read_attribute_history_3.n",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_3_get_attribute_config_3_return, {"Seq length of AttributeConfigList_3","giop-tango.Device.get_attribute_config_3.return",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_3_get_attribute_config_3_names, {"Seq length of names","giop-tango.Device.get_attribute_config_3.names",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_Device_3_set_attribute_config_3_new_conf, {"Seq length of new_conf","giop-tango.Device.set_attribute_config_3.new_conf",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        /* Attribute filters */
        {&hf_get_Tango_Device_name_name, {"name","giop-tango.Device.name.get",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_get_Tango_Device_description_description, {"description","giop-tango.Device.description.get",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_get_Tango_Device_state_state, {"state","giop-tango.Device.state.get",FT_UINT32,BASE_DEC,VALS(Tango_DevState),0x0,NULL,HFILL}},
        {&hf_get_Tango_Device_status_status, {"status","giop-tango.Device.status.get",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_get_Tango_Device_adm_name_adm_name, {"adm_name","giop-tango.Device.adm_name.get",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        /* Struct filters */
        {&hf_Tango_DevVarLongStringArray_lvalue, {"Seq length of DevVarLongStringArray_lvalue","giop-tango.DevVarLongStringArray.lvalue",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevVarLongStringArray_svalue, {"Seq length of DevVarLongStringArray_svalue","giop-tango.DevVarLongStringArray.svalue",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevVarDoubleStringArray_dvalue, {"Seq length of DevVarDoubleStringArray_dvalue","giop-tango.DevVarDoubleStringArray.dvalue",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevVarDoubleStringArray_svalue, {"Seq length of DevVarDoubleStringArray_svalue","giop-tango.DevVarDoubleStringArray.svalue",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_TimeVal_tv_sec, {"TimeVal_tv_sec","giop-tango.TimeVal.tv_sec",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_TimeVal_tv_usec, {"TimeVal_tv_usec","giop-tango.TimeVal.tv_usec",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_TimeVal_tv_nsec, {"TimeVal_tv_nsec","giop-tango.TimeVal.tv_nsec",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevCmdInfo_cmd_name, {"DevCmdInfo_cmd_name","giop-tango.DevCmdInfo.cmd_name",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevCmdInfo_cmd_tag, {"DevCmdInfo_cmd_tag","giop-tango.DevCmdInfo.cmd_tag",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevCmdInfo_in_type, {"DevCmdInfo_in_type","giop-tango.DevCmdInfo.in_type",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevCmdInfo_out_type, {"DevCmdInfo_out_type","giop-tango.DevCmdInfo.out_type",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevCmdInfo_in_type_desc, {"DevCmdInfo_in_type_desc","giop-tango.DevCmdInfo.in_type_desc",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevCmdInfo_out_type_desc, {"DevCmdInfo_out_type_desc","giop-tango.DevCmdInfo.out_type_desc",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevCmdInfo_2_cmd_name, {"DevCmdInfo_2_cmd_name","giop-tango.DevCmdInfo_2.cmd_name",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevCmdInfo_2_level, {"DevCmdInfo_2_level","giop-tango.DevCmdInfo_2.level",FT_UINT32,BASE_DEC,VALS(Tango_DispLevel),0x0,NULL,HFILL}},
        {&hf_Tango_DevCmdInfo_2_cmd_tag, {"DevCmdInfo_2_cmd_tag","giop-tango.DevCmdInfo_2.cmd_tag",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevCmdInfo_2_in_type, {"DevCmdInfo_2_in_type","giop-tango.DevCmdInfo_2.in_type",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevCmdInfo_2_out_type, {"DevCmdInfo_2_out_type","giop-tango.DevCmdInfo_2.out_type",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevCmdInfo_2_in_type_desc, {"DevCmdInfo_2_in_type_desc","giop-tango.DevCmdInfo_2.in_type_desc",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevCmdInfo_2_out_type_desc, {"DevCmdInfo_2_out_type_desc","giop-tango.DevCmdInfo_2.out_type_desc",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevError_reason, {"DevError_reason","giop-tango.DevError.reason",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevError_severity, {"DevError_severity","giop-tango.DevError.severity",FT_UINT32,BASE_DEC,VALS(Tango_ErrSeverity),0x0,NULL,HFILL}},
        {&hf_Tango_DevError_desc, {"DevError_desc","giop-tango.DevError.desc",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevError_origin, {"DevError_origin","giop-tango.DevError.origin",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_NamedDevError_name, {"NamedDevError_name","giop-tango.NamedDevError.name",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_NamedDevError_index_in_call, {"NamedDevError_index_in_call","giop-tango.NamedDevError.index_in_call",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_NamedDevError_err_list, {"Seq length of NamedDevError_err_list","giop-tango.NamedDevError.err_list",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_name, {"AttributeConfig_name","giop-tango.AttributeConfig.name",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_writable, {"AttributeConfig_writable","giop-tango.AttributeConfig.writable",FT_UINT32,BASE_DEC,VALS(Tango_AttrWriteType),0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_data_format, {"AttributeConfig_data_format","giop-tango.AttributeConfig.data_format",FT_UINT32,BASE_DEC,VALS(Tango_AttrDataFormat),0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_data_type, {"AttributeConfig_data_type","giop-tango.AttributeConfig.data_type",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_max_dim_x, {"AttributeConfig_max_dim_x","giop-tango.AttributeConfig.max_dim_x",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_max_dim_y, {"AttributeConfig_max_dim_y","giop-tango.AttributeConfig.max_dim_y",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_description, {"AttributeConfig_description","giop-tango.AttributeConfig.description",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_label, {"AttributeConfig_label","giop-tango.AttributeConfig.label",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_unit, {"AttributeConfig_unit","giop-tango.AttributeConfig.unit",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_standard_unit, {"AttributeConfig_standard_unit","giop-tango.AttributeConfig.standard_unit",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_display_unit, {"AttributeConfig_display_unit","giop-tango.AttributeConfig.display_unit",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_format, {"AttributeConfig_format","giop-tango.AttributeConfig.format",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_min_value, {"AttributeConfig_min_value","giop-tango.AttributeConfig.min_value",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_max_value, {"AttributeConfig_max_value","giop-tango.AttributeConfig.max_value",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_min_alarm, {"AttributeConfig_min_alarm","giop-tango.AttributeConfig.min_alarm",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_max_alarm, {"AttributeConfig_max_alarm","giop-tango.AttributeConfig.max_alarm",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_writable_attr_name, {"AttributeConfig_writable_attr_name","giop-tango.AttributeConfig.writable_attr_name",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_extensions, {"Seq length of AttributeConfig_extensions","giop-tango.AttributeConfig.extensions",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_2_name, {"AttributeConfig_2_name","giop-tango.AttributeConfig_2.name",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_2_writable, {"AttributeConfig_2_writable","giop-tango.AttributeConfig_2.writable",FT_UINT32,BASE_DEC,VALS(Tango_AttrWriteType),0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_2_data_format, {"AttributeConfig_2_data_format","giop-tango.AttributeConfig_2.data_format",FT_UINT32,BASE_DEC,VALS(Tango_AttrDataFormat),0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_2_data_type, {"AttributeConfig_2_data_type","giop-tango.AttributeConfig_2.data_type",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_2_max_dim_x, {"AttributeConfig_2_max_dim_x","giop-tango.AttributeConfig_2.max_dim_x",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_2_max_dim_y, {"AttributeConfig_2_max_dim_y","giop-tango.AttributeConfig_2.max_dim_y",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_2_description, {"AttributeConfig_2_description","giop-tango.AttributeConfig_2.description",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_2_label, {"AttributeConfig_2_label","giop-tango.AttributeConfig_2.label",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_2_unit, {"AttributeConfig_2_unit","giop-tango.AttributeConfig_2.unit",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_2_standard_unit, {"AttributeConfig_2_standard_unit","giop-tango.AttributeConfig_2.standard_unit",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_2_display_unit, {"AttributeConfig_2_display_unit","giop-tango.AttributeConfig_2.display_unit",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_2_format, {"AttributeConfig_2_format","giop-tango.AttributeConfig_2.format",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_2_min_value, {"AttributeConfig_2_min_value","giop-tango.AttributeConfig_2.min_value",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_2_max_value, {"AttributeConfig_2_max_value","giop-tango.AttributeConfig_2.max_value",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_2_min_alarm, {"AttributeConfig_2_min_alarm","giop-tango.AttributeConfig_2.min_alarm",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_2_max_alarm, {"AttributeConfig_2_max_alarm","giop-tango.AttributeConfig_2.max_alarm",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_2_writable_attr_name, {"AttributeConfig_2_writable_attr_name","giop-tango.AttributeConfig_2.writable_attr_name",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_2_level, {"AttributeConfig_2_level","giop-tango.AttributeConfig_2.level",FT_UINT32,BASE_DEC,VALS(Tango_DispLevel),0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_2_extensions, {"Seq length of AttributeConfig_2_extensions","giop-tango.AttributeConfig_2.extensions",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeValue_quality, {"AttributeValue_quality","giop-tango.AttributeValue.quality",FT_UINT32,BASE_DEC,VALS(Tango_AttrQuality),0x0,NULL,HFILL}},
        {&hf_Tango_AttributeValue_name, {"AttributeValue_name","giop-tango.AttributeValue.name",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeValue_dim_x, {"AttributeValue_dim_x","giop-tango.AttributeValue.dim_x",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeValue_dim_y, {"AttributeValue_dim_y","giop-tango.AttributeValue.dim_y",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeDim_dim_x, {"AttributeDim_dim_x","giop-tango.AttributeDim.dim_x",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeDim_dim_y, {"AttributeDim_dim_y","giop-tango.AttributeDim.dim_y",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeValue_3_quality, {"AttributeValue_3_quality","giop-tango.AttributeValue_3.quality",FT_UINT32,BASE_DEC,VALS(Tango_AttrQuality),0x0,NULL,HFILL}},
        {&hf_Tango_AttributeValue_3_name, {"AttributeValue_3_name","giop-tango.AttributeValue_3.name",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeValue_3_err_list, {"Seq length of AttributeValue_3_err_list","giop-tango.AttributeValue_3.err_list",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_ChangeEventProp_rel_change, {"ChangeEventProp_rel_change","giop-tango.ChangeEventProp.rel_change",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_ChangeEventProp_abs_change, {"ChangeEventProp_abs_change","giop-tango.ChangeEventProp.abs_change",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_ChangeEventProp_extensions, {"Seq length of ChangeEventProp_extensions","giop-tango.ChangeEventProp.extensions",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_PeriodicEventProp_period, {"PeriodicEventProp_period","giop-tango.PeriodicEventProp.period",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_PeriodicEventProp_extensions, {"Seq length of PeriodicEventProp_extensions","giop-tango.PeriodicEventProp.extensions",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_ArchiveEventProp_rel_change, {"ArchiveEventProp_rel_change","giop-tango.ArchiveEventProp.rel_change",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_ArchiveEventProp_abs_change, {"ArchiveEventProp_abs_change","giop-tango.ArchiveEventProp.abs_change",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_ArchiveEventProp_period, {"ArchiveEventProp_period","giop-tango.ArchiveEventProp.period",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_ArchiveEventProp_extensions, {"Seq length of ArchiveEventProp_extensions","giop-tango.ArchiveEventProp.extensions",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeAlarm_min_alarm, {"AttributeAlarm_min_alarm","giop-tango.AttributeAlarm.min_alarm",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeAlarm_max_alarm, {"AttributeAlarm_max_alarm","giop-tango.AttributeAlarm.max_alarm",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeAlarm_min_warning, {"AttributeAlarm_min_warning","giop-tango.AttributeAlarm.min_warning",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeAlarm_max_warning, {"AttributeAlarm_max_warning","giop-tango.AttributeAlarm.max_warning",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeAlarm_delta_t, {"AttributeAlarm_delta_t","giop-tango.AttributeAlarm.delta_t",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeAlarm_delta_val, {"AttributeAlarm_delta_val","giop-tango.AttributeAlarm.delta_val",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeAlarm_extensions, {"Seq length of AttributeAlarm_extensions","giop-tango.AttributeAlarm.extensions",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_3_name, {"AttributeConfig_3_name","giop-tango.AttributeConfig_3.name",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_3_writable, {"AttributeConfig_3_writable","giop-tango.AttributeConfig_3.writable",FT_UINT32,BASE_DEC,VALS(Tango_AttrWriteType),0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_3_data_format, {"AttributeConfig_3_data_format","giop-tango.AttributeConfig_3.data_format",FT_UINT32,BASE_DEC,VALS(Tango_AttrDataFormat),0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_3_data_type, {"AttributeConfig_3_data_type","giop-tango.AttributeConfig_3.data_type",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_3_max_dim_x, {"AttributeConfig_3_max_dim_x","giop-tango.AttributeConfig_3.max_dim_x",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_3_max_dim_y, {"AttributeConfig_3_max_dim_y","giop-tango.AttributeConfig_3.max_dim_y",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_3_description, {"AttributeConfig_3_description","giop-tango.AttributeConfig_3.description",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_3_label, {"AttributeConfig_3_label","giop-tango.AttributeConfig_3.label",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_3_unit, {"AttributeConfig_3_unit","giop-tango.AttributeConfig_3.unit",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_3_standard_unit, {"AttributeConfig_3_standard_unit","giop-tango.AttributeConfig_3.standard_unit",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_3_display_unit, {"AttributeConfig_3_display_unit","giop-tango.AttributeConfig_3.display_unit",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_3_format, {"AttributeConfig_3_format","giop-tango.AttributeConfig_3.format",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_3_min_value, {"AttributeConfig_3_min_value","giop-tango.AttributeConfig_3.min_value",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_3_max_value, {"AttributeConfig_3_max_value","giop-tango.AttributeConfig_3.max_value",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_3_writable_attr_name, {"AttributeConfig_3_writable_attr_name","giop-tango.AttributeConfig_3.writable_attr_name",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_3_level, {"AttributeConfig_3_level","giop-tango.AttributeConfig_3.level",FT_UINT32,BASE_DEC,VALS(Tango_DispLevel),0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_3_extensions, {"Seq length of AttributeConfig_3_extensions","giop-tango.AttributeConfig_3.extensions",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_AttributeConfig_3_sys_extensions, {"Seq length of AttributeConfig_3_sys_extensions","giop-tango.AttributeConfig_3.sys_extensions",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevInfo_dev_class, {"DevInfo_dev_class","giop-tango.DevInfo.dev_class",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevInfo_server_id, {"DevInfo_server_id","giop-tango.DevInfo.server_id",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevInfo_server_host, {"DevInfo_server_host","giop-tango.DevInfo.server_host",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevInfo_server_version, {"DevInfo_server_version","giop-tango.DevInfo.server_version",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevInfo_doc_url, {"DevInfo_doc_url","giop-tango.DevInfo.doc_url",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevInfo_3_dev_class, {"DevInfo_3_dev_class","giop-tango.DevInfo_3.dev_class",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevInfo_3_server_id, {"DevInfo_3_server_id","giop-tango.DevInfo_3.server_id",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevInfo_3_server_host, {"DevInfo_3_server_host","giop-tango.DevInfo_3.server_host",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevInfo_3_server_version, {"DevInfo_3_server_version","giop-tango.DevInfo_3.server_version",FT_INT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevInfo_3_doc_url, {"DevInfo_3_doc_url","giop-tango.DevInfo_3.doc_url",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevInfo_3_dev_type, {"DevInfo_3_dev_type","giop-tango.DevInfo_3.dev_type",FT_STRING,BASE_NONE,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevCmdHistory_cmd_failed, {"DevCmdHistory_cmd_failed","giop-tango.DevCmdHistory.cmd_failed",FT_BOOLEAN,8,NULL,0x01,NULL,HFILL}},
        {&hf_Tango_DevCmdHistory_errors, {"Seq length of DevCmdHistory_errors","giop-tango.DevCmdHistory.errors",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevAttrHistory_attr_failed, {"DevAttrHistory_attr_failed","giop-tango.DevAttrHistory.attr_failed",FT_BOOLEAN,8,NULL,0x01,NULL,HFILL}},
        {&hf_Tango_DevAttrHistory_errors, {"Seq length of DevAttrHistory_errors","giop-tango.DevAttrHistory.errors",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_DevAttrHistory_3_attr_failed, {"DevAttrHistory_3_attr_failed","giop-tango.DevAttrHistory_3.attr_failed",FT_BOOLEAN,8,NULL,0x01,NULL,HFILL}},
        /* User exception filters */
        {&hf_Tango_DevFailed_errors, {"Seq length of DevFailed_errors","giop-tango.DevFaile.DevFailed_errors",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        {&hf_Tango_MultiDevFailed_errors, {"Seq length of MultiDevFailed_errors","giop-tango.MultiDevFaile.MultiDevFailed_errors",FT_UINT32,BASE_DEC,NULL,0x0,NULL,HFILL}},
        /* Union filters */

   };

   static ei_register_info ei[] = {
      { &ei_tango_unknown_giop_msg, { "giop-tango.unknown_giop_msg", PI_PROTOCOL, PI_WARN, "Unknown GIOP message", EXPFILL }},
      { &ei_tango_unknown_exception, { "giop-tango.unknown_exception", PI_PROTOCOL, PI_WARN, "Unknown exception", EXPFILL }},
      { &ei_tango_unknown_reply_status, { "giop-tango.unknown_reply_status", PI_PROTOCOL, PI_WARN, "Unknown reply status", EXPFILL }},
   };

   /* setup protocol subtree array */

   static gint *ett[] = {
      &ett_tango,
   };

   expert_module_t* expert_tango;


   /* Register the protocol name and description */
   proto_tango = proto_register_protocol("Tango Dissector Using GIOP API" , "TANGO", "giop-tango" );
   proto_register_field_array(proto_tango, hf, array_length(hf));
   proto_register_subtree_array(ett, array_length(ett));

   expert_tango = expert_register_protocol(proto_tango);
   expert_register_field_array(expert_tango, ei, array_length(ei));
}

/* register me as handler for these interfaces */
void proto_reg_handoff_giop_tango(void)
{
    
    /* Register for Explicit Dissection */
    register_giop_user_module(dissect_tango, "TANGO", "Tango/Device", proto_tango );     /* explicit dissector */
    
    /* Register for Explicit Dissection */
    register_giop_user_module(dissect_tango, "TANGO", "Tango/Device_2", proto_tango );     /* explicit dissector */
    
    /* Register for Explicit Dissection */
    register_giop_user_module(dissect_tango, "TANGO", "Tango/Device_3", proto_tango );     /* explicit dissector */
    
    /* Register for Heuristic Dissection */
    register_giop_user(dissect_tango, "TANGO" ,proto_tango);     /* heuristic dissector */
}

