/* qt_gui_utils.h
 * Tango theme colors
 *
 * $Id$
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __TANGO_COLORS_H__
#define __TANGO_COLORS_H__

// http://tango.freedesktop.org/Tango_Icon_Theme_Guidelines
// with added hues from http://emilis.info/other/extended_tango/
// (all colors except aluminium)

const QRgb tango_aluminium_1   = 0xeeeeec;
const QRgb tango_aluminium_2   = 0xd3d7cf;
const QRgb tango_aluminium_3   = 0xbabdb6;
const QRgb tango_aluminium_4   = 0x888a85;
const QRgb tango_aluminium_5   = 0x555753;
const QRgb tango_aluminium_6   = 0x2e3436;

const QRgb tango_butter_1      = 0xfeffd0;
const QRgb tango_butter_2      = 0xfffc9c;
const QRgb tango_butter_3      = 0xfce94f;
const QRgb tango_butter_4      = 0xedd400;
const QRgb tango_butter_5      = 0xc4a000;
const QRgb tango_butter_6      = 0x725000;

const QRgb tango_chameleon_1   = 0xe4ffc7;
const QRgb tango_chameleon_2   = 0xb7f774;
const QRgb tango_chameleon_3   = 0x8ae234;
const QRgb tango_chameleon_4   = 0x73d216;
const QRgb tango_chameleon_5   = 0x4e9a06;
const QRgb tango_chameleon_6   = 0x2a5703;

const QRgb tango_chocolate_1   = 0xfaf0d7;
const QRgb tango_chocolate_2   = 0xefd0a7;
const QRgb tango_chocolate_3   = 0xe9b96e;
const QRgb tango_chocolate_4   = 0xc17d11;
const QRgb tango_chocolate_5   = 0x8f5902;
const QRgb tango_chocolate_6   = 0x503000;

const QRgb tango_orange_1      = 0xfff0d7;
const QRgb tango_orange_2      = 0xffd797;
const QRgb tango_orange_3      = 0xfcaf3e;
const QRgb tango_orange_4      = 0xf57900;
const QRgb tango_orange_5      = 0xce5c00;
const QRgb tango_orange_6      = 0x8c3700;

const QRgb tango_plum_1        = 0xfce0ff;
const QRgb tango_plum_2        = 0xe0c0e4;
const QRgb tango_plum_3        = 0xad7fa8;
const QRgb tango_plum_4        = 0x75507b;
const QRgb tango_plum_5        = 0x5c3566;
const QRgb tango_plum_6        = 0x371740;

const QRgb tango_scarlet_red_1 = 0xffcccc;
const QRgb tango_scarlet_red_2 = 0xf78787;
const QRgb tango_scarlet_red_3 = 0xef2929;
const QRgb tango_scarlet_red_4 = 0xcc0000;
const QRgb tango_scarlet_red_5 = 0xa40000;
const QRgb tango_scarlet_red_6 = 0x600000;

const QRgb tango_sky_blue_1    = 0xdaeeff;
const QRgb tango_sky_blue_2    = 0x97c4f0;
const QRgb tango_sky_blue_3    = 0x729fcf;
const QRgb tango_sky_blue_4    = 0x3465a4;
const QRgb tango_sky_blue_5    = 0x204a87;
const QRgb tango_sky_blue_6    = 0x0a3050;

const QRgb ws_css_warn_background = tango_butter_2;
const QRgb ws_css_warn_text       = tango_aluminium_6;

#endif // __TANGO_COLORS_H__
